<?php

/**
 * Class that operate on table 'usergroup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class UsergroupMySqlDAO implements UsergroupDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return UsergroupMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM usergroup where usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM usergroup ORDER BY ' . $orderColumn . ' where usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param usergroup primary key
     */
    public function delete($usergroupid) {
        $sql = 'DELETE FROM usergroup WHERE usergroupid = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param UsergroupMySql usergroup
     */
    public function insert($usergroup) {
        $sql = 'INSERT INTO usergroup (usergroupname, usergroupdescription, currentdate, conditions, startpage, level,savedailydate ,hidemenu,hidecat,clientnegative,suplliernegative,storenegative,directDiscount,percentageDiscount,priceupdate,allowEditDelInBills,allowEditDelInBuyBills,showsStorerQuantity,showSellAllPrice,showSellHalfPrice,showSellUnitPrice,showBuyPrice,productno,kempilano,productnotsellno,clientcheckno,suppliercheckno,productRequist,otherRequist,toWorkShopOrder,insuranceBill,sellreportpricetype ,netprofit , hideproductcatid ,directSaveBills,seeAllHalls,homePageIcon,sendKitchen,printKitchen,endBill,endPrintBill,showManualBackup,autoKitchenPrint,takeAway,delivery,hall,deleteMovementManage,allowBillDelete,billDeletePassword,reviewBillsAllowedTables,downloadClientPhones,showstoredetailprice,stopDiscountOfTotalControl,discountOfTotalControlEditable,discountOfTotalControlMTGDA,kitchenPayedVal,kitchenPayedChange,showsIndexStatistics,restaurantplaystationpalyBtn,restaurantDefaultPage,mandobMethod,showsIndexCharts,addClientInBill,addsupplierInBill,hideBillPrices,editUserPrivlage,showSerializeBtn,showClientAndSupplierOne,allowStoreMoveUpdateDel,showsIndexProductBelowLimitReport,storeSupervisorShow,showProfitInsideBill,showSaveBalanceAfterClose,dontChooseStore,canEditAddDiscountPercentage,noBillEditIfTheirIsPayments,showTotalBuyBill) VALUES (?,?,?, ?, ?, ?, ?, ?,?,? ,?,?,?,?,?,?,? ,? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($usergroup->usergroupname);
        $sqlQuery->setString2($usergroup->usergroupdescription);
        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber((int) $usergroup->conditions);
        $sqlQuery->set($usergroup->startpage);
        $sqlQuery->setNumber((int) $usergroup->level);
        $sqlQuery->set($usergroup->savedailydate);
        $sqlQuery->setNumber((int) $usergroup->hidemenu);
        $sqlQuery->setNumber((int) $usergroup->hidecat);
        $sqlQuery->setNumber((int) $usergroup->clientnegative);
        $sqlQuery->setNumber((int) $usergroup->suplliernegative);
        $sqlQuery->setNumber((int) $usergroup->storenegative);
        $sqlQuery->set($usergroup->directDiscount);
        $sqlQuery->set($usergroup->percentageDiscount);
        $sqlQuery->set($usergroup->priceupdate);
        $sqlQuery->setNumber((int) $usergroup->allowEditDelInBills);
        $sqlQuery->setNumber((int) $usergroup->allowEditDelInBuyBills);

        $sqlQuery->setNumber((int) $usergroup->showsStorerQuantity);
        $sqlQuery->setNumber((int) $usergroup->showSellAllPrice);
        $sqlQuery->setNumber((int) $usergroup->showSellHalfPrice);
        $sqlQuery->setNumber((int) $usergroup->showSellUnitPrice);
        $sqlQuery->setNumber((int) $usergroup->showBuyPrice);

        $sqlQuery->setNumber((int) $usergroup->productno);
        $sqlQuery->setNumber((int) $usergroup->kempilano);
        $sqlQuery->setNumber((int) $usergroup->productnotsellno);
        $sqlQuery->setNumber((int) $usergroup->clientcheckno);
        $sqlQuery->setNumber((int) $usergroup->suppliercheckno);
        $sqlQuery->setNumber((int) $usergroup->productRequist);
        $sqlQuery->setNumber((int) $usergroup->otherRequist);
        $sqlQuery->setNumber((int) $usergroup->toWorkShopOrder);
        $sqlQuery->setNumber((int) $usergroup->insuranceBill);
        $sqlQuery->setNumber((int) $usergroup->sellreportpricetype);
        $sqlQuery->setNumber((int) $usergroup->netprofit);
        $sqlQuery->setNumber((int) $usergroup->hideproductcatid);
        $sqlQuery->setNumber((int) $usergroup->directSaveBills);
        $sqlQuery->setNumber((int) $usergroup->seeAllHalls);
        $sqlQuery->setNumber((int) $usergroup->homePageIcon);
        $sqlQuery->setNumber((int) $usergroup->sendKitchen);
        $sqlQuery->setNumber((int) $usergroup->printKitchen);
        $sqlQuery->setNumber((int) $usergroup->endBill);
        $sqlQuery->setNumber((int) $usergroup->endPrintBill);
        $sqlQuery->setNumber((int) $usergroup->showManualBackup);
        $sqlQuery->setNumber((int) $usergroup->autoKitchenPrint);
        $sqlQuery->setNumber((int) $usergroup->takeAway);
        $sqlQuery->setNumber((int) $usergroup->delivery);
        $sqlQuery->setNumber((int) $usergroup->hall);
        $sqlQuery->setNumber((int) $usergroup->deleteMovementManage);
        $sqlQuery->setNumber((int) $usergroup->allowBillDelete);
        $sqlQuery->set($usergroup->billDeletePassword);
        $sqlQuery->set($usergroup->reviewBillsAllowedTables);
        $sqlQuery->setNumber((int) $usergroup->downloadClientPhones);
        $sqlQuery->setNumber((int) $usergroup->showstoredetailprice);
        $sqlQuery->setNumber((int) $usergroup->stopDiscountOfTotalControl);
        $sqlQuery->setNumber((int) $usergroup->discountOfTotalControlEditable);
        $sqlQuery->setNumber((int) $usergroup->discountOfTotalControlMTGDA);
        $sqlQuery->setNumber((int) $usergroup->kitchenPayedVal);
        $sqlQuery->setNumber((int) $usergroup->kitchenPayedChange);
        $sqlQuery->setNumber((int) $usergroup->showsIndexStatistics);
        $sqlQuery->setNumber((int) $usergroup->restaurantplaystationpalyBtn);
        $sqlQuery->setNumber((int) $usergroup->restaurantDefaultPage);
        $sqlQuery->setNumber((int) $usergroup->mandobMethod);
        $sqlQuery->setNumber((int) $usergroup->showsIndexCharts);
        $sqlQuery->setNumber((int) $usergroup->addClientInBill);
        $sqlQuery->setNumber((int) $usergroup->addsupplierInBill);
        $sqlQuery->setNumber((int) $usergroup->hideBillPrices);
        $sqlQuery->setNumber((int) $usergroup->editUserPrivlage);
        $sqlQuery->setNumber((int) $usergroup->showSerializeBtn);
        $sqlQuery->setNumber((int) $usergroup->showClientAndSupplierOne);
        $sqlQuery->setNumber((int) $usergroup->allowStoreMoveUpdateDel);
        $sqlQuery->setNumber((int) $usergroup->showsIndexProductBelowLimitReport);
        $sqlQuery->setNumber((int) $usergroup->storeSupervisorShow);
        $sqlQuery->setNumber((int) $usergroup->showProfitInsideBill);
        $sqlQuery->setNumber((int) $usergroup->showSaveBalanceAfterClose);
        $sqlQuery->setNumber((int) $usergroup->dontChooseStore);
        $sqlQuery->setNumber((int) $usergroup->canEditAddDiscountPercentage);
        $sqlQuery->setNumber((int) $usergroup->noBillEditIfTheirIsPayments);
        $sqlQuery->setNumber((int) $usergroup->showTotalBuyBill);
        $id = $this->executeInsert($sqlQuery);
        $usergroup->usergroupid = $id;


        return $id;
    }

    /**
     * Update record in table
     *
     * @param UsergroupMySql usergroup
     */
    public function update($usergroup) {
        $sql = 'UPDATE usergroup SET usergroupname = ?, usergroupdescription = ?, currentdate = ?, conditions = ?, startpage = ?, level = ? ,savedailydate=? ,
		hidemenu = ?, hidecat = ?,clientnegative= ?,suplliernegative=?,storenegative=?, directDiscount = ?, percentageDiscount = ?, priceupdate = ?,
                allowEditDelInBills = ?,allowEditDelInBuyBills = ?,
                showsStorerQuantity = ?,showSellAllPrice = ?,showSellHalfPrice = ?,showSellUnitPrice = ?,showBuyPrice = ?,

                productno = ?,kempilano = ?,productnotsellno = ?,clientcheckno = ?,suppliercheckno = ?,productRequist = ?,otherRequist = ?,toWorkShopOrder = ?,insuranceBill = ?,
                sellreportpricetype = ? , netprofit = ? , hideproductcatid = ?,directSaveBills = ?,seeAllHalls = ?,homePageIcon = ?,
                sendKitchen = ?,printKitchen = ?,endBill = ?,endPrintBill = ?,showManualBackup = ?,autoKitchenPrint=?,takeAway=?,delivery=?,hall=?,deleteMovementManage = ?,
                allowBillDelete = ?,billDeletePassword = ?,reviewBillsAllowedTables = ?,downloadClientPhones = ?,showstoredetailprice = ?,
                stopDiscountOfTotalControl = ?,discountOfTotalControlEditable = ?,discountOfTotalControlMTGDA = ?,kitchenPayedVal = ?,kitchenPayedChange = ?,showsIndexStatistics = ?,
                restaurantplaystationpalyBtn= ?,restaurantDefaultPage=?,showsIndexCharts = ?,addClientInBill = ?,addsupplierInBill = ?,hideBillPrices=?,editUserPrivlage=?,showSerializeBtn=?,showClientAndSupplierOne=?,allowStoreMoveUpdateDel=?,showsIndexProductBelowLimitReport=?,
                storeSupervisorShow=?,showProfitInsideBill=?,showSaveBalanceAfterClose=?,dontChooseStore=?,canEditAddDiscountPercentage=?,noBillEditIfTheirIsPayments=?,showTotalBuyBill=?
		WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($usergroup->usergroupname);
        $sqlQuery->setString2($usergroup->usergroupdescription);
        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber((int) $usergroup->conditions);
        $sqlQuery->set($usergroup->startpage);
        $sqlQuery->setNumber((int) $usergroup->level);
        $sqlQuery->setNumber((int) $usergroup->savedailydate);

        $sqlQuery->setNumber((int) $usergroup->hidemenu);
        $sqlQuery->setNumber((int) $usergroup->hidecat);

        $sqlQuery->setNumber((int) $usergroup->clientnegative);
        $sqlQuery->setNumber((int) $usergroup->suplliernegative);
        $sqlQuery->setNumber((int) $usergroup->storenegative);

        $sqlQuery->set($usergroup->directDiscount);
        $sqlQuery->set($usergroup->percentageDiscount);
        $sqlQuery->setNumber((int) $usergroup->priceupdate);
        $sqlQuery->setNumber((int) $usergroup->allowEditDelInBills);
        $sqlQuery->setNumber((int) $usergroup->allowEditDelInBuyBills);

        $sqlQuery->setNumber((int) $usergroup->showsStorerQuantity);
        $sqlQuery->setNumber((int) $usergroup->showSellAllPrice);
        $sqlQuery->setNumber((int) $usergroup->showSellHalfPrice);
        $sqlQuery->setNumber((int) $usergroup->showSellUnitPrice);
        $sqlQuery->setNumber((int) $usergroup->showBuyPrice);

        $sqlQuery->setNumber((int) $usergroup->productno);
        $sqlQuery->setNumber((int) $usergroup->kempilano);
        $sqlQuery->setNumber((int) $usergroup->productnotsellno);
        $sqlQuery->setNumber((int) $usergroup->clientcheckno);
        $sqlQuery->setNumber((int) $usergroup->suppliercheckno);
        $sqlQuery->setNumber((int) $usergroup->productRequist);
        $sqlQuery->setNumber((int) $usergroup->otherRequist);
        $sqlQuery->setNumber((int) $usergroup->toWorkShopOrder);
        $sqlQuery->setNumber((int) $usergroup->insuranceBill);
        $sqlQuery->setNumber((int) $usergroup->sellreportpricetype);
        $sqlQuery->setNumber((int) $usergroup->netprofit);
        $sqlQuery->setNumber((int) $usergroup->hideproductcatid);
        $sqlQuery->setNumber((int) $usergroup->directSaveBills);
        $sqlQuery->setNumber((int) $usergroup->seeAllHalls);
        $sqlQuery->setNumber((int) $usergroup->homePageIcon);
        $sqlQuery->setNumber((int) $usergroup->sendKitchen);
        $sqlQuery->setNumber((int) $usergroup->printKitchen);
        $sqlQuery->setNumber((int) $usergroup->endBill);
        $sqlQuery->setNumber((int) $usergroup->endPrintBill);
        $sqlQuery->setNumber((int) $usergroup->showManualBackup);
        $sqlQuery->setNumber((int) $usergroup->autoKitchenPrint);
        $sqlQuery->setNumber((int) $usergroup->takeAway);
        $sqlQuery->setNumber((int) $usergroup->delivery);
        $sqlQuery->setNumber((int) $usergroup->hall);
        $sqlQuery->setNumber((int) $usergroup->deleteMovementManage);
        $sqlQuery->setNumber((int) $usergroup->allowBillDelete);
        $sqlQuery->set($usergroup->billDeletePassword);
        $sqlQuery->set($usergroup->reviewBillsAllowedTables);
        $sqlQuery->setNumber((int) $usergroup->downloadClientPhones);
        $sqlQuery->setNumber((int) $usergroup->showstoredetailprice);
        $sqlQuery->setNumber((int) $usergroup->stopDiscountOfTotalControl);
        $sqlQuery->setNumber((int) $usergroup->discountOfTotalControlEditable);
        $sqlQuery->setNumber((int) $usergroup->discountOfTotalControlMTGDA);
        $sqlQuery->setNumber((int) $usergroup->kitchenPayedVal);
        $sqlQuery->setNumber((int) $usergroup->kitchenPayedChange);
        $sqlQuery->setNumber((int) $usergroup->showsIndexStatistics);
        $sqlQuery->setNumber((int) $usergroup->restaurantplaystationpalyBtn);
        $sqlQuery->setNumber((int) $usergroup->restaurantDefaultPage);
        $sqlQuery->setNumber((int) $usergroup->showsIndexCharts);
        $sqlQuery->setNumber((int) $usergroup->addClientInBill);
        $sqlQuery->setNumber((int) $usergroup->addsupplierInBill);
        $sqlQuery->setNumber((int) $usergroup->hideBillPrices);
        $sqlQuery->setNumber((int) $usergroup->editUserPrivlage);
        $sqlQuery->setNumber((int) $usergroup->showSerializeBtn);
        $sqlQuery->setNumber((int) $usergroup->showClientAndSupplierOne);
        $sqlQuery->setNumber((int) $usergroup->allowStoreMoveUpdateDel);
        $sqlQuery->setNumber((int) $usergroup->showsIndexProductBelowLimitReport);
        $sqlQuery->setNumber((int) $usergroup->storeSupervisorShow);
        $sqlQuery->setNumber((int) $usergroup->showProfitInsideBill);
        $sqlQuery->setNumber((int) $usergroup->showSaveBalanceAfterClose);
        $sqlQuery->setNumber((int) $usergroup->dontChooseStore);
        $sqlQuery->setNumber((int) $usergroup->canEditAddDiscountPercentage);
        $sqlQuery->setNumber((int) $usergroup->noBillEditIfTheirIsPayments);
        $sqlQuery->setNumber((int) $usergroup->showTotalBuyBill);

        $sqlQuery->setNumber($usergroup->usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM usergroup';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUsergroupname($value) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupname = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUsergroupdescription($value) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupdescription = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM usergroup WHERE currentdate = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM usergroup WHERE conditions = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStartpage($value) {
        $sql = 'SELECT * FROM usergroup WHERE startpage = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLevel($value) {
        $sql = 'SELECT * FROM usergroup WHERE level = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUsergroupname($value) {
        $sql = 'DELETE FROM usergroup WHERE usergroupname = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUsergroupdescription($value) {
        $sql = 'DELETE FROM usergroup WHERE usergroupdescription = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM usergroup WHERE currentdate = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM usergroup WHERE conditions = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStartpage($value) {
        $sql = 'DELETE FROM usergroup WHERE startpage = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLevel($value) {
        $sql = 'DELETE FROM usergroup WHERE level = ? and usergroupid > 0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return UsergroupMySql
     */
    protected function readRow($row) {
        $usergroup = new Usergroup();

        $usergroup->usergroupid = isset($row['usergroupid']) ? $row['usergroupid'] : '';
        $usergroup->usergroupname = isset($row['usergroupname']) ? $row['usergroupname'] : '';
        $usergroup->usergroupdescription = isset($row['usergroupdescription']) ? $row['usergroupdescription'] : '';
        $usergroup->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';
        $usergroup->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $usergroup->startpage = isset($row['startpage']) ? $row['startpage'] : '';
        $usergroup->level = isset($row['level']) ? $row['level'] : '';
        $usergroup->savedailydate = isset($row['savedailydate']) ? $row['savedailydate'] : '';

        $usergroup->hidemenu = isset($row['hidemenu']) ? $row['hidemenu'] : '';
        $usergroup->hidecat = isset($row['hidecat']) ? $row['hidecat'] : '';

        $usergroup->clientnegative = isset($row['clientnegative']) ? $row['clientnegative'] : '';
        $usergroup->suplliernegative = isset($row['suplliernegative']) ? $row['suplliernegative'] : '';
        $usergroup->storenegative = isset($row['storenegative']) ? $row['storenegative'] : '';


        $usergroup->directDiscount = isset($row['directDiscount']) ? $row['directDiscount'] : '';
        $usergroup->percentageDiscount = isset($row['percentageDiscount']) ? $row['percentageDiscount'] : '';
        $usergroup->priceupdate = isset($row['priceupdate']) ? $row['priceupdate'] : '';
        $usergroup->allowEditDelInBills = isset($row['allowEditDelInBills']) ? $row['allowEditDelInBills'] : '';
        $usergroup->allowEditDelInBuyBills = isset($row['allowEditDelInBuyBills']) ? $row['allowEditDelInBuyBills'] : '';

        $usergroup->showsStorerQuantity = isset($row['showsStorerQuantity']) ? $row['showsStorerQuantity'] : '';
        $usergroup->showSellAllPrice = isset($row['showSellAllPrice']) ? $row['showSellAllPrice'] : '';
        $usergroup->showSellHalfPrice = isset($row['showSellHalfPrice']) ? $row['showSellHalfPrice'] : '';
        $usergroup->showSellUnitPrice = isset($row['showSellUnitPrice']) ? $row['showSellUnitPrice'] : '';
        $usergroup->showBuyPrice = isset($row['showBuyPrice']) ? $row['showBuyPrice'] : '';

        $usergroup->productno = isset($row['productno']) ? $row['productno'] : '';
        $usergroup->kempilano = isset($row['kempilano']) ? $row['kempilano'] : '';
        $usergroup->productnotsellno = isset($row['productnotsellno']) ? $row['productnotsellno'] : '';
        $usergroup->clientcheckno = isset($row['clientcheckno']) ? $row['clientcheckno'] : '';
        $usergroup->suppliercheckno = isset($row['suppliercheckno']) ? $row['suppliercheckno'] : '';
        $usergroup->productRequist = isset($row['productRequist']) ? $row['productRequist'] : '';
        $usergroup->otherRequist = isset($row['otherRequist']) ? $row['otherRequist'] : '';
        $usergroup->toWorkShopOrder = isset($row['toWorkShopOrder']) ? $row['toWorkShopOrder'] : '';
        $usergroup->insuranceBill = isset($row['insuranceBill']) ? $row['insuranceBill'] : '';
        $usergroup->sellreportpricetype = isset($row['sellreportpricetype']) ? $row['sellreportpricetype'] : '';
        $usergroup->netprofit = isset($row['netprofit']) ? $row['netprofit'] : '';
        $usergroup->hideproductcatid = isset($row['hideproductcatid']) ? $row['hideproductcatid'] : '';
        $usergroup->directSaveBills = isset($row['directSaveBills']) ? $row['directSaveBills'] : '';
        $usergroup->seeAllHalls = isset($row['seeAllHalls']) ? $row['seeAllHalls'] : '';
        $usergroup->homePageIcon = isset($row['homePageIcon']) ? $row['homePageIcon'] : '';
        $usergroup->sendKitchen = isset($row['sendKitchen']) ? $row['sendKitchen'] : '';
        $usergroup->printKitchen = isset($row['printKitchen']) ? $row['printKitchen'] : '';
        $usergroup->endBill = isset($row['endBill']) ? $row['endBill'] : '';
        $usergroup->endPrintBill = isset($row['endPrintBill']) ? $row['endPrintBill'] : '';
        $usergroup->showManualBackup = isset($row['showManualBackup']) ? $row['showManualBackup'] : '';
        $usergroup->autoKitchenPrint = isset($row['autoKitchenPrint']) ? $row['autoKitchenPrint'] : '';
        $usergroup->takeAway = isset($row['takeAway']) ? $row['takeAway'] : '';
        $usergroup->delivery = isset($row['delivery']) ? $row['delivery'] : '';
        $usergroup->hall = isset($row['hall']) ? $row['hall'] : '';
        $usergroup->deleteMovementManage = isset($row['deleteMovementManage']) ? $row['deleteMovementManage'] : '';
        $usergroup->allowBillDelete = isset($row['allowBillDelete']) ? $row['allowBillDelete'] : '';
        $usergroup->billDeletePassword = isset($row['billDeletePassword']) ? $row['billDeletePassword'] : '';
        $usergroup->reviewBillsAllowedTables = isset($row['reviewBillsAllowedTables']) ? $row['reviewBillsAllowedTables'] : '';
        $usergroup->downloadClientPhones = isset($row['downloadClientPhones']) ? $row['downloadClientPhones'] : '';
        $usergroup->showstoredetailprice = isset($row['showstoredetailprice']) ? $row['showstoredetailprice'] : '';
        $usergroup->stopDiscountOfTotalControl = isset($row['stopDiscountOfTotalControl']) ? $row['stopDiscountOfTotalControl'] : '';
        $usergroup->discountOfTotalControlEditable = isset($row['discountOfTotalControlEditable']) ? $row['discountOfTotalControlEditable'] : '';
        $usergroup->discountOfTotalControlMTGDA = isset($row['discountOfTotalControlMTGDA']) ? $row['discountOfTotalControlMTGDA'] : '';
        $usergroup->kitchenPayedVal = isset($row['kitchenPayedVal']) ? $row['kitchenPayedVal'] : '';
        $usergroup->kitchenPayedChange = isset($row['kitchenPayedChange']) ? $row['kitchenPayedChange'] : '';
        $usergroup->showsIndexStatistics = isset($row['showsIndexStatistics']) ? $row['showsIndexStatistics'] : '';
        $usergroup->restaurantplaystationpalyBtn = isset($row['restaurantplaystationpalyBtn']) ? $row['restaurantplaystationpalyBtn'] : '';
        $usergroup->restaurantDefaultPage = isset($row['restaurantDefaultPage']) ? $row['restaurantDefaultPage'] : '';
        $usergroup->mandobMethod = isset($row['mandobMethod']) ? $row['mandobMethod'] : '';
        $usergroup->showsIndexCharts = isset($row['showsIndexCharts']) ? $row['showsIndexCharts'] : '';
        $usergroup->addClientInBill = isset($row['addClientInBill']) ? $row['addClientInBill'] : '';
        $usergroup->addsupplierInBill = isset($row['addsupplierInBill']) ? $row['addsupplierInBill'] : '';
        $usergroup->hideBillPrices = isset($row['hideBillPrices']) ? $row['hideBillPrices'] : '';
        $usergroup->editUserPrivlage = isset($row['editUserPrivlage']) ? $row['editUserPrivlage'] : '';
        $usergroup->showSerializeBtn = isset($row['showSerializeBtn']) ? $row['showSerializeBtn'] : '';
        $usergroup->showClientAndSupplierOne = isset($row['showClientAndSupplierOne']) ? $row['showClientAndSupplierOne'] : '';
        $usergroup->allowStoreMoveUpdateDel = isset($row['allowStoreMoveUpdateDel']) ? $row['allowStoreMoveUpdateDel'] : '';
        $usergroup->showsIndexProductBelowLimitReport = isset($row['showsIndexProductBelowLimitReport']) ? $row['showsIndexProductBelowLimitReport'] : '';
        $usergroup->storeSupervisorShow = isset($row['storeSupervisorShow']) ? $row['storeSupervisorShow'] : '';
        $usergroup->showProfitInsideBill = isset($row['showProfitInsideBill']) ? $row['showProfitInsideBill'] : '';
        $usergroup->showSaveBalanceAfterClose = isset($row['showSaveBalanceAfterClose']) ? $row['showSaveBalanceAfterClose'] : '';
        $usergroup->dontChooseStore = isset($row['dontChooseStore']) ? $row['dontChooseStore'] : '';
        $usergroup->canEditAddDiscountPercentage = isset($row['canEditAddDiscountPercentage']) ? $row['canEditAddDiscountPercentage'] : '';
        $usergroup->noBillEditIfTheirIsPayments = isset($row['noBillEditIfTheirIsPayments']) ? $row['noBillEditIfTheirIsPayments'] : '';
        $usergroup->showTotalBuyBill = isset($row['showTotalBuyBill']) ? $row['showTotalBuyBill'] : '';

        return $usergroup;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return UsergroupMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>